<?php
/**
 * Template da página de pagamento PIX - Versão Profissional
 */

if (!defined('ABSPATH')) {
    exit;
}

$order = wc_get_order($order_id);
if (!$order) {
    return;
}

$payment_id = $order->get_meta('_pix_payment_id');
$payment_code = $order->get_meta('_pix_payment_code');
$qr_code_image = $order->get_meta('_pix_qr_code_image');
$asaas_data = $order->get_meta('_pix_asaas_data');
$amount = $order->get_total();

// Decodificar dados do Asaas
$asaas_info = null;
if ($asaas_data) {
    $asaas_info = json_decode($asaas_data, true);
}
?>

<div class="wc-pix-payment-wrapperssss">
    <div class="wc-pix-payment-container" data-order-id="<?php echo esc_attr($order->get_id()); ?>">
        
        <!-- Header com informações do pedido -->
        <div class="wc-pix-header">
            <div class="wc-pix-header-content">
                <div class="wc-pix-logo">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="24" height="24" rx="4" fill="#00C851"/>
                        <path d="M8 12L10.5 14.5L16 9" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="wc-pix-header-text">
                    <h1><?php _e('Pagamento PIX', 'woocommerce-pix-gateway'); ?></h1>
                    <p><?php _e('Escaneie o QR Code ou copie o código PIX para realizar o pagamento', 'woocommerce-pix-gateway'); ?></p>
                </div>
            </div>
        </div>


        <!-- QR Code e Código PIX -->
        <div class="wc-pix-payment-section">
            <div class="wc-pix-qr-container">
                <?php if ($qr_code_image): ?>
                    <div class="wc-pix-qr-wrapper">
                        <?php
                        // Se a API retornou somente o base64, prefixar para data URL
                        $qr_src = $qr_code_image;
                        if ($qr_src && strpos($qr_src, 'http') !== 0 && strpos($qr_src, 'data:') !== 0) {
                            $qr_src = 'data:image/png;base64,' . $qr_src;
                        }
                        ?>
                        <div class="wc-pix-qr-code">
                            <img src="<?php echo esc_attr($qr_src); ?>" 
                                 alt="<?php _e('QR Code PIX', 'woocommerce-pix-gateway'); ?>"
                                 class="wc-pix-qr-image">
                        </div>
                        <p class="wc-pix-qr-instruction"><?php _e('Aponte a câmera do seu celular para o QR Code', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                <?php elseif ($payment_code): ?>
                    <div class="wc-pix-qr-wrapper">
                        <div class="wc-pix-qr-code">
                            <div id="pix-qr-generated" class="wc-pix-qr-generated"></div>
                        </div>
                        <p class="wc-pix-qr-instruction"><?php _e('Aponte a câmera do seu celular para o QR Code', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <?php if ($payment_code): ?>
            <div class="wc-pix-code-section">
                <div class="wc-pix-code-header">
                    <h3><?php _e('Ou copie o código PIX', 'woocommerce-pix-gateway'); ?></h3>
                    <p><?php _e('Cole este código no seu aplicativo bancário', 'woocommerce-pix-gateway'); ?></p>
                </div>
                <div class="wc-pix-code-container">
                    <div class="wc-pix-code-input-wrapper">
                        <textarea id="pix-code" readonly class="wc-pix-code-input"><?php echo esc_textarea($payment_code); ?></textarea>
                        <button type="button" class="wc-pix-copy-btn" onclick="copyPixCode()">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect x="9" y="9" width="13" height="13" rx="2" ry="2" stroke="currentColor" stroke-width="2" fill="none"/>
                                <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" stroke="currentColor" stroke-width="2" fill="none"/>
                            </svg>
                            <span class="wc-pix-copy-text"><?php _e('Copiar', 'woocommerce-pix-gateway'); ?></span>
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Status do pagamento -->
        <div class="wc-pix-status-section">
            <div class="wc-pix-status-card">
                <div class="wc-pix-status-icon pending" id="status-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <polyline points="12,6 12,12 16,14" stroke="currentColor" stroke-width="2"/>
                    </svg>
                </div>
                <div class="wc-pix-status-content">
                    <h4 id="status-message"><?php _e('Aguardando pagamento...', 'woocommerce-pix-gateway'); ?></h4>
                    <p id="status-detail"><?php _e('Após realizar o pagamento, o status será atualizado automaticamente.', 'woocommerce-pix-gateway'); ?></p>
                </div>
            </div>
        </div>

        <!-- Instruções -->
        <div class="wc-pix-instructions">
            <h3><?php _e('Como pagar com PIX', 'woocommerce-pix-gateway'); ?></h3>
            <div class="wc-pix-steps">
                <div class="wc-pix-step">
                    <div class="wc-pix-step-number">1</div>
                    <div class="wc-pix-step-content">
                        <h4><?php _e('Abra seu app bancário', 'woocommerce-pix-gateway'); ?></h4>
                        <p><?php _e('Acesse o aplicativo do seu banco ou instituição financeira', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                </div>
                <div class="wc-pix-step">
                    <div class="wc-pix-step-number">2</div>
                    <div class="wc-pix-step-content">
                        <h4><?php _e('Escolha PIX', 'woocommerce-pix-gateway'); ?></h4>
                        <p><?php _e('Selecione a opção PIX ou Pagamento por QR Code', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                </div>
                <div class="wc-pix-step">
                    <div class="wc-pix-step-number">3</div>
                    <div class="wc-pix-step-content">
                        <h4><?php _e('Escaneie ou cole o código', 'woocommerce-pix-gateway'); ?></h4>
                        <p><?php _e('Use a câmera para escanear o QR Code ou cole o código PIX', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                </div>
                <div class="wc-pix-step">
                    <div class="wc-pix-step-number">4</div>
                    <div class="wc-pix-step-content">
                        <h4><?php _e('Confirme o pagamento', 'woocommerce-pix-gateway'); ?></h4>
                        <p><?php _e('Verifique os dados e confirme a transação', 'woocommerce-pix-gateway'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Informações importantes -->
        <div class="wc-pix-info-section">
            <div class="wc-pix-info-card">
                <div class="wc-pix-info-icon">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                        <line x1="12" y1="16" x2="12" y2="12" stroke="currentColor" stroke-width="2"/>
                        <line x1="12" y1="8" x2="12.01" y2="8" stroke="currentColor" stroke-width="2"/>
                    </svg>
                </div>
                <div class="wc-pix-info-content">
                    <h4><?php _e('Informações importantes', 'woocommerce-pix-gateway'); ?></h4>
                    <ul>
                        <li><?php _e('O pagamento PIX é processado instantaneamente', 'woocommerce-pix-gateway'); ?></li>
                        <li><?php _e('Após a confirmação, seu pedido será processado automaticamente', 'woocommerce-pix-gateway'); ?></li>
                        <li><?php _e('Você receberá um e-mail de confirmação', 'woocommerce-pix-gateway'); ?></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Ações -->
        <div class="wc-pix-actions">
            <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="wc-pix-btn wc-pix-btn-secondary">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M19 12H5M12 19l-7-7 7-7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <?php _e('Voltar ao Checkout', 'woocommerce-pix-gateway'); ?>
            </a>
            
            <div class="wc-pix-support">
                <p><?php _e('Precisa de ajuda?', 'woocommerce-pix-gateway'); ?> 
                   <a href="<?php echo esc_url(home_url('/contato')); ?>"><?php _e('Entre em contato', 'woocommerce-pix-gateway'); ?></a>
                </p>
            </div>
        </div>

    </div>
</div>

<!-- JavaScript será carregado via arquivo externo frontend.js -->

<style>
    
    
 /**
 * Estilos modernos e responsivos para o Berapay - Frontend
 * Versão Profissional
 */

/* Reset e variáveis CSS - Tema Cinza Profissional */
:root {
    /* Cores principais - Cinza profissional */
    --wc-pix-primary: #6C757D;
    --wc-pix-primary-dark: #495057;
    --wc-pix-primary-light: #ADB5BD;
    --wc-pix-primary-lighter: #E9ECEF;
    --wc-pix-primary-lightest: #F8F9FA;
    
    /* Cores secundárias */
    --wc-pix-secondary: #6C757D;
    --wc-pix-success: #4CAF50;
    --wc-pix-warning: #FF9800;
    --wc-pix-danger: #F44336;
    --wc-pix-info: #2196F3;
    
    /* Tons de cinza suaves */
    --wc-pix-light: #F8F9FA;
    --wc-pix-dark: #2E2E2E;
    --wc-pix-white: #FFFFFF;
    --wc-pix-gray-50: #FAFAFA;
    --wc-pix-gray-100: #F5F5F5;
    --wc-pix-gray-200: #EEEEEE;
    --wc-pix-gray-300: #E0E0E0;
    --wc-pix-gray-400: #BDBDBD;
    --wc-pix-gray-500: #9E9E9E;
    --wc-pix-gray-600: #757575;
    --wc-pix-gray-700: #616161;
    --wc-pix-gray-800: #424242;
    --wc-pix-gray-900: #212121;
    
    /* Sombras suaves */
    --wc-pix-shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.1);
    --wc-pix-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    --wc-pix-shadow-lg: 0 8px 16px rgba(0, 0, 0, 0.2);
    --wc-pix-shadow-xl: 0 12px 24px rgba(0, 0, 0, 0.25);
    
    /* Bordas arredondadas */
    --wc-pix-border-radius: 12px;
    --wc-pix-border-radius-sm: 8px;
    --wc-pix-border-radius-lg: 16px;
    --wc-pix-border-radius-xl: 20px;
    
    /* Tipografia */
    --wc-pix-font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
    --wc-pix-font-size-xs: 0.75rem;
    --wc-pix-font-size-sm: 0.875rem;
    --wc-pix-font-size-base: 1rem;
    --wc-pix-font-size-lg: 1.125rem;
    --wc-pix-font-size-xl: 1.25rem;
    --wc-pix-font-size-2xl: 1.5rem;
    --wc-pix-font-size-3xl: 1.875rem;
    
    /* Espaçamentos */
    --wc-pix-spacing-xs: 0.25rem;
    --wc-pix-spacing-sm: 0.5rem;
    --wc-pix-spacing-md: 1rem;
    --wc-pix-spacing-lg: 1.5rem;
    --wc-pix-spacing-xl: 2rem;
    --wc-pix-spacing-2xl: 3rem;
    --wc-pix-spacing-3xl: 4rem;
}

/* Container principal */
.wc-pix-payment-wrapper {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--wc-pix-primary-lightest) 0%, var(--wc-pix-gray-100) 100%);
    padding: 0;
    font-family: var(--wc-pix-font-family);
    display: block;
}

/* Padding lateral para telas muito grandes */
@media (min-width: 1600px) {
    .wc-pix-payment-wrapper {
        padding: 0 var(--wc-pix-spacing-2xl);
    }
}

.wc-pix-payment-container {
    width: 100%;
    max-width: none;
    background: var(--wc-pix-white);
    border-radius: 0;
    box-shadow: none;
    overflow: hidden;
    animation: wc-pix-fadeInUp 0.6s ease-out;
    margin: 0;
}

/* Header */
.wc-pix-header {
    background: linear-gradient(135deg, var(--wc-pix-primary) 0%, var(--wc-pix-primary-dark) 100%);
    color: var(--wc-pix-white);
    padding: var(--wc-pix-spacing-xl) var(--wc-pix-spacing-2xl);
    text-align: center;
    box-shadow: var(--wc-pix-shadow-lg);
}

.wc-pix-header-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: var(--wc-pix-spacing-lg);
}

.wc-pix-logo {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
}

.wc-pix-header-text h1 {
    font-size: var(--wc-pix-font-size-3xl);
    font-weight: 700;
    margin: 0 0 var(--wc-pix-spacing-sm) 0;
    line-height: 1.2;
}

.wc-pix-header-text p {
    font-size: var(--wc-pix-font-size-lg);
    margin: 0;
    opacity: 0.9;
    line-height: 1.5;
}


/* Seção de pagamento */
.wc-pix-payment-section {
    padding: var(--wc-pix-spacing-2xl);
    max-width: 1200px;
    margin: 0 auto;
}

.wc-pix-qr-container {
    text-align: center;
    margin-bottom: var(--wc-pix-spacing-2xl);
}

.wc-pix-qr-wrapper {
    display: inline-block;
    padding: var(--wc-pix-spacing-xl);
    background: var(--wc-pix-white);
    border: 2px solid var(--wc-pix-gray-200);
    border-radius: var(--wc-pix-border-radius-lg);
    box-shadow: var(--wc-pix-shadow);
}

.wc-pix-qr-code {
    margin-bottom: var(--wc-pix-spacing-lg);
}

.wc-pix-qr-image {
    max-width: 280px;
    width: 100%;
    height: auto;
    border-radius: var(--wc-pix-border-radius);
    box-shadow: var(--wc-pix-shadow);
}

.wc-pix-qr-generated {
    width: 280px;
    height: 280px;
    margin: 0 auto;
    border-radius: var(--wc-pix-border-radius);
    box-shadow: var(--wc-pix-shadow);
}

.wc-pix-qr-instruction {
    font-size: var(--wc-pix-font-size-base);
    color: var(--wc-pix-gray-600);
    margin: 0;
    font-weight: 500;
}

/* Seção do código PIX */
.wc-pix-code-section {
    background: var(--wc-pix-gray-100);
    border-radius: var(--wc-pix-border-radius-lg);
    padding: var(--wc-pix-spacing-xl);
    margin-top: var(--wc-pix-spacing-xl);
}

.wc-pix-code-header {
    text-align: center;
    margin-bottom: var(--wc-pix-spacing-lg);
}

.wc-pix-code-header h3 {
    font-size: var(--wc-pix-font-size-xl);
    font-weight: 700;
    color: var(--wc-pix-gray-800);
    margin: 0 0 var(--wc-pix-spacing-sm) 0;
}

.wc-pix-code-header p {
    font-size: var(--wc-pix-font-size-base);
    color: var(--wc-pix-gray-600);
    margin: 0;
}

.wc-pix-code-container {
    max-width: 600px;
    margin: 0 auto;
}

.wc-pix-code-input-wrapper {
    display: flex;
    gap: var(--wc-pix-spacing-md);
    align-items: flex-start;
}

.wc-pix-code-input {
    flex: 1;
    min-height: 120px;
    padding: var(--wc-pix-spacing-lg);
    border: 2px solid var(--wc-pix-gray-300);
    border-radius: var(--wc-pix-border-radius);
    font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    font-size: var(--wc-pix-font-size-sm);
    line-height: 1.5;
    background: var(--wc-pix-white);
    color: var(--wc-pix-gray-800);
    resize: vertical;
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
}

.wc-pix-code-input:focus {
    outline: none;
    border-color: var(--wc-pix-primary);
    box-shadow: 0 0 0 3px rgba(0, 200, 81, 0.1);
}

.wc-pix-copy-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: var(--wc-pix-spacing-sm);
    padding: var(--wc-pix-spacing-lg);
    background: var(--wc-pix-primary);
    color: var(--wc-pix-white);
    border: none;
    border-radius: var(--wc-pix-border-radius);
    font-size: var(--wc-pix-font-size-sm);
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    min-width: 100px;
    box-shadow: var(--wc-pix-shadow-sm);
}

.wc-pix-copy-btn:hover {
    background: var(--wc-pix-primary-dark);
    transform: translateY(-2px);
    box-shadow: var(--wc-pix-shadow);
}

.wc-pix-copy-btn:active {
    transform: translateY(0);
}

.wc-pix-copy-btn.copied {
    background: var(--wc-pix-success);
    animation: wc-pix-pulse 0.6s ease-out;
}

.wc-pix-copy-text {
    font-size: var(--wc-pix-font-size-sm);
    font-weight: 600;
}

/* Status do pagamento */
.wc-pix-status-section {
    padding: 0 var(--wc-pix-spacing-2xl) var(--wc-pix-spacing-2xl);
    max-width: 1200px;
    margin: 0 auto;
}

.wc-pix-status-card {
    display: flex;
    align-items: center;
    gap: var(--wc-pix-spacing-lg);
    padding: var(--wc-pix-spacing-xl);
    background: var(--wc-pix-gray-100);
    border-radius: var(--wc-pix-border-radius-lg);
    border-left: 4px solid var(--wc-pix-warning);
}

.wc-pix-status-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--wc-pix-white);
    flex-shrink: 0;
    transition: all 0.3s ease;
}

.wc-pix-status-icon.pending {
    background: var(--wc-pix-warning);
    animation: wc-pix-pulse 2s infinite;
}

.wc-pix-status-icon.confirmed {
    background: var(--wc-pix-success);
    border-left-color: var(--wc-pix-success);
}

.wc-pix-status-icon.overdue {
    background: var(--wc-pix-danger);
    border-left-color: var(--wc-pix-danger);
}

.wc-pix-status-icon.cancelled {
    background: var(--wc-pix-secondary);
    border-left-color: var(--wc-pix-secondary);
}

.wc-pix-status-content {
    flex: 1;
}

.wc-pix-status-content h4 {
    font-size: var(--wc-pix-font-size-lg);
    font-weight: 700;
    color: var(--wc-pix-gray-800);
    margin: 0 0 var(--wc-pix-spacing-sm) 0;
}

.wc-pix-status-content p {
    font-size: var(--wc-pix-font-size-base);
    color: var(--wc-pix-gray-600);
    margin: 0;
    line-height: 1.5;
}

/* Instruções */
.wc-pix-instructions {
    padding: var(--wc-pix-spacing-2xl);
    background: var(--wc-pix-white);
    border-top: 1px solid var(--wc-pix-gray-200);
    max-width: 1200px;
    margin: 0 auto;
}

.wc-pix-instructions h3 {
    font-size: var(--wc-pix-font-size-2xl);
    font-weight: 700;
    color: var(--wc-pix-gray-800);
    text-align: center;
    margin: 0 0 var(--wc-pix-spacing-2xl) 0;
}

.wc-pix-steps {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: var(--wc-pix-spacing-xl);
}

.wc-pix-step {
    display: flex;
    gap: var(--wc-pix-spacing-lg);
    align-items: flex-start;
}

.wc-pix-step-number {
    width: 40px;
    height: 40px;
    background: var(--wc-pix-primary);
    color: var(--wc-pix-white);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: var(--wc-pix-font-size-lg);
    font-weight: 700;
    flex-shrink: 0;
}

.wc-pix-step-content h4 {
    font-size: var(--wc-pix-font-size-lg);
    font-weight: 600;
    color: var(--wc-pix-gray-800);
    margin: 0 0 var(--wc-pix-spacing-sm) 0;
}

.wc-pix-step-content p {
    font-size: var(--wc-pix-font-size-base);
    color: var(--wc-pix-gray-600);
    margin: 0;
    line-height: 1.5;
}

/* Informações importantes */
.wc-pix-info-section {
    padding: 0 var(--wc-pix-spacing-2xl) var(--wc-pix-spacing-2xl);
    max-width: 1200px;
    margin: 0 auto;
}

.wc-pix-info-card {
    display: flex;
    gap: var(--wc-pix-spacing-lg);
    padding: var(--wc-pix-spacing-xl);
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
    border-radius: var(--wc-pix-border-radius-lg);
    border-left: 4px solid var(--wc-pix-warning);
}

.wc-pix-info-icon {
    width: 40px;
    height: 40px;
    background: var(--wc-pix-warning);
    color: var(--wc-pix-white);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.wc-pix-info-content h4 {
    font-size: var(--wc-pix-font-size-lg);
    font-weight: 700;
    color: var(--wc-pix-gray-800);
    margin: 0 0 var(--wc-pix-spacing-md) 0;
}

.wc-pix-info-content ul {
    margin: 0;
    padding-left: var(--wc-pix-spacing-lg);
    color: var(--wc-pix-gray-700);
}

.wc-pix-info-content li {
    margin-bottom: var(--wc-pix-spacing-sm);
    line-height: 1.5;
}

/* Ações */
.wc-pix-actions {
    padding: var(--wc-pix-spacing-2xl);
    background: var(--wc-pix-gray-100);
    border-top: 1px solid var(--wc-pix-gray-200);
    text-align: center;
    max-width: 1200px;
    margin: 0 auto;
}

.wc-pix-btn {
    display: inline-flex;
    align-items: center;
    gap: var(--wc-pix-spacing-sm);
    padding: var(--wc-pix-spacing-lg) var(--wc-pix-spacing-xl);
    border: none;
    border-radius: var(--wc-pix-border-radius);
    font-size: var(--wc-pix-font-size-base);
    font-weight: 600;
    text-decoration: none;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: var(--wc-pix-shadow-sm);
}

.wc-pix-btn-secondary {
    background: var(--wc-pix-secondary);
    color: var(--wc-pix-white);
}

.wc-pix-btn-secondary:hover {
    background: var(--wc-pix-gray-700);
    transform: translateY(-2px);
    box-shadow: var(--wc-pix-shadow);
    color: var(--wc-pix-white);
    text-decoration: none;
}

.wc-pix-support {
    margin-top: var(--wc-pix-spacing-lg);
    font-size: var(--wc-pix-font-size-sm);
    color: var(--wc-pix-gray-600);
}

.wc-pix-support a {
    color: var(--wc-pix-primary);
    text-decoration: none;
    font-weight: 600;
}

.wc-pix-support a:hover {
    text-decoration: underline;
}

/* Mensagens */
.wc-pix-message {
    display: flex;
    align-items: center;
    gap: var(--wc-pix-spacing-md);
    padding: var(--wc-pix-spacing-lg);
    margin: var(--wc-pix-spacing-lg) var(--wc-pix-spacing-2xl);
    border-radius: var(--wc-pix-border-radius);
    font-size: var(--wc-pix-font-size-base);
    font-weight: 500;
    animation: wc-pix-slideInDown 0.3s ease-out;
}

.wc-pix-message-success {
    background: #d4edda;
    border-left: 4px solid var(--wc-pix-success);
    color: #155724;
}

.wc-pix-message-error {
    background: #f8d7da;
    border-left: 4px solid var(--wc-pix-danger);
    color: #721c24;
}

.wc-pix-message-info {
    background: #d1ecf1;
    border-left: 4px solid var(--wc-pix-info);
    color: #0c5460;
}

.wc-pix-message-warning {
    background: #fff3cd;
    border-left: 4px solid var(--wc-pix-warning);
    color: #856404;
}

/* Animações */
@keyframes wc-pix-fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes wc-pix-pulse {
    0% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.05);
    }
    100% {
        transform: scale(1);
    }
}

@keyframes wc-pix-slideInDown {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Estados de loading */
.wc-pix-loading {
    opacity: 0.6;
    pointer-events: none;
    position: relative;
}

.wc-pix-loading::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 24px;
    height: 24px;
    margin: -12px 0 0 -12px;
    border: 3px solid var(--wc-pix-gray-300);
    border-top: 3px solid var(--wc-pix-primary);
    border-radius: 50%;
    animation: wc-pix-spin 1s linear infinite;
}

@keyframes wc-pix-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Responsividade para Desktop Grande */
@media (min-width: 1400px) {
    .wc-pix-payment-section {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: var(--wc-pix-spacing-2xl);
        align-items: start;
    }
    
    .wc-pix-qr-container {
        margin-bottom: 0;
    }
    
    .wc-pix-code-section {
        margin-top: 0;
    }
    
    .wc-pix-steps {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Responsividade para Desktop */
@media (min-width: 1024px) and (max-width: 1399px) {
    .wc-pix-steps {
        grid-template-columns: repeat(2, 1fr);
    }
}

/* Responsividade para Tablet */
@media (max-width: 1023px) {
    .wc-pix-payment-section,
    .wc-pix-status-section,
    .wc-pix-instructions,
    .wc-pix-info-section,
    .wc-pix-actions {
        padding: var(--wc-pix-spacing-xl);
    }
}

/* Responsividade para Mobile */
@media (max-width: 768px) {
    .wc-pix-header {
        padding: var(--wc-pix-spacing-xl);
    }
    
    .wc-pix-header-content {
        gap: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-logo {
        width: 60px;
        height: 60px;
    }
    
    .wc-pix-header-text h1 {
        font-size: var(--wc-pix-font-size-2xl);
    }
    
    .wc-pix-header-text p {
        font-size: var(--wc-pix-font-size-base);
    }
    
    .wc-pix-payment-section,
    .wc-pix-status-section,
    .wc-pix-instructions,
    .wc-pix-info-section,
    .wc-pix-actions {
        padding: var(--wc-pix-spacing-lg);
    }
    
    .wc-pix-qr-wrapper {
        padding: var(--wc-pix-spacing-lg);
    }
    
    .wc-pix-qr-image,
    .wc-pix-qr-generated {
        max-width: 240px;
        width: 100%;
    }
    
    .wc-pix-qr-generated {
        width: 240px;
        height: 240px;
    }
    
    .wc-pix-code-input-wrapper {
        flex-direction: column;
        gap: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-copy-btn {
        flex-direction: row;
        justify-content: center;
        min-width: auto;
    }
    
    .wc-pix-status-card {
        flex-direction: column;
        text-align: center;
        gap: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-status-icon {
        width: 50px;
        height: 50px;
    }
    
    .wc-pix-steps {
        grid-template-columns: 1fr;
        gap: var(--wc-pix-spacing-lg);
    }
    
    .wc-pix-step {
        flex-direction: column;
        text-align: center;
        gap: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-info-card {
        flex-direction: column;
        text-align: center;
        gap: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-message {
        margin: var(--wc-pix-spacing-md);
        flex-direction: column;
        text-align: center;
        gap: var(--wc-pix-spacing-sm);
    }
}

@media (max-width: 480px) {
    .wc-pix-payment-wrapper {
        padding: var(--wc-pix-spacing-sm);
    }
    
    .wc-pix-header {
        padding: var(--wc-pix-spacing-lg);
    }
    
    .wc-pix-header-text h1 {
        font-size: var(--wc-pix-font-size-xl);
    }
    
    .wc-pix-payment-section,
    .wc-pix-status-section,
    .wc-pix-instructions,
    .wc-pix-info-section,
    .wc-pix-actions {
        padding: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-qr-image,
    .wc-pix-qr-generated {
        max-width: 200px;
    }
    
    .wc-pix-qr-generated {
        width: 200px;
        height: 200px;
    }
    
    .wc-pix-code-input {
        min-height: 100px;
        font-size: var(--wc-pix-font-size-xs);
    }
    
    .wc-pix-instructions h3 {
        font-size: var(--wc-pix-font-size-xl);
    }
    
    .wc-pix-step-number {
        width: 35px;
        height: 35px;
        font-size: var(--wc-pix-font-size-base);
    }
    
    .wc-pix-btn {
        width: 100%;
        justify-content: center;
    }
}

/* Estilos para checkout (compatibilidade) - Tema Verde Claro */
.wc-pix-description {
    margin: 8px 0 16px;
    color: var(--wc-pix-gray-600);
    font-size: var(--wc-pix-font-size-sm);
    line-height: 1.5;
}

.woocommerce-checkout #payment .payment_box .wc-pix-gateway-fields,
.wc-pix-gateway-fields {
    background: var(--wc-pix-white);
    border: 2px solid var(--wc-pix-primary-lighter);
    border-radius: var(--wc-pix-border-radius-lg);
    padding: var(--wc-pix-spacing-xl);
    box-shadow: var(--wc-pix-shadow);
    margin-bottom: var(--wc-pix-spacing-lg);
    overflow: hidden;
}

.woocommerce-checkout #payment .payment_box .wc-pix-options,
.wc-pix-options {
    display: grid;
    grid-template-columns: 1fr;
    gap: var(--wc-pix-spacing-md);
    margin-bottom: var(--wc-pix-spacing-lg);
}

.woocommerce-checkout #payment .payment_box .wc-pix-option,
.wc-pix-option {
    background: var(--wc-pix-white);
    border: 2px solid var(--wc-pix-gray-200);
    border-radius: var(--wc-pix-border-radius);
    padding: var(--wc-pix-spacing-lg);
    display: flex;
    align-items: center;
    gap: var(--wc-pix-spacing-md);
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.woocommerce-checkout #payment .payment_box .wc-pix-option:hover,
.wc-pix-option:hover {
    background: var(--wc-pix-primary-lightest);
    border-color: var(--wc-pix-primary-light);
    transform: translateY(-2px);
    box-shadow: var(--wc-pix-shadow-sm);
}

.woocommerce-checkout #payment .payment_box .wc-pix-option input:checked + span,
.wc-pix-option input:checked + span {
    color: var(--wc-pix-primary-dark);
    font-weight: 700;
}

.woocommerce-checkout #payment .payment_box .wc-pix-option input:checked,
.wc-pix-option input:checked {
    accent-color: var(--wc-pix-primary);
}

.woocommerce-checkout #payment .payment_box .wc-pix-option:has(input:checked),
.wc-pix-option:has(input:checked) {
    background: var(--wc-pix-primary-lightest);
    border-color: var(--wc-pix-primary);
    box-shadow: var(--wc-pix-shadow-sm);
}

.woocommerce-checkout #payment .payment_box .wc-pix-option input,
.wc-pix-option input {
    margin: 0;
    width: 20px;
    height: 20px;
    accent-color: var(--wc-pix-primary);
    flex-shrink: 0;
}

.woocommerce-checkout #payment .payment_box .wc-pix-option span,
.wc-pix-option span {
    font-weight: 600;
    color: var(--wc-pix-gray-800);
    font-size: var(--wc-pix-font-size-base);
    flex: 1;
}

.woocommerce-checkout #payment .payment_box .wc-pix-card,
.wc-pix-card {
    background: var(--wc-pix-primary-lightest);
    border: 2px solid var(--wc-pix-primary-lighter);
    border-radius: var(--wc-pix-border-radius);
    padding: var(--wc-pix-spacing-lg);
    margin-top: var(--wc-pix-spacing-md);
    box-shadow: var(--wc-pix-shadow-sm);
    overflow: hidden;
}

.wc-pix-row {
    margin-bottom: var(--wc-pix-spacing-lg);
}

.wc-pix-row:last-child {
    margin-bottom: 0;
}

.wc-pix-row label {
    display: block;
    font-size: var(--wc-pix-font-size-sm);
    color: var(--wc-pix-gray-700);
    margin-bottom: var(--wc-pix-spacing-sm);
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.woocommerce-checkout #payment .payment_box .wc-pix-input,
.wc-pix-input {
    width: 100%;
    padding: var(--wc-pix-spacing-md) var(--wc-pix-spacing-lg);
    border: 2px solid var(--wc-pix-gray-300);
    border-radius: var(--wc-pix-border-radius);
    background: var(--wc-pix-white);
    font-size: var(--wc-pix-font-size-base);
    line-height: 1.5;
    transition: all 0.3s ease;
    box-sizing: border-box;
    font-family: var(--wc-pix-font-family);
}

.woocommerce-checkout #payment .payment_box .wc-pix-input:focus,
.wc-pix-input:focus {
    outline: none;
    border-color: var(--wc-pix-primary);
    box-shadow: 0 0 0 4px var(--wc-pix-primary-lighter);
    background: var(--wc-pix-white);
}

.woocommerce-checkout #payment .payment_box .wc-pix-input::placeholder,
.wc-pix-input::placeholder {
    color: var(--wc-pix-gray-500);
    font-style: italic;
}

.wc-pix-row-inline {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: var(--wc-pix-spacing-md);
    align-items: end;
}

.wc-pix-col {
    display: flex;
    flex-direction: column;
}

/* Responsividade melhorada */
@media (max-width: 768px) {
    .woocommerce-checkout #payment .payment_box .wc-pix-gateway-fields,
    .wc-pix-gateway-fields {
        padding: var(--wc-pix-spacing-lg);
        margin-bottom: var(--wc-pix-spacing-md);
    }
    
    .woocommerce-checkout #payment .payment_box .wc-pix-option,
    .wc-pix-option {
        padding: var(--wc-pix-spacing-md);
        gap: var(--wc-pix-spacing-sm);
    }
    
    .wc-pix-row-inline {
        grid-template-columns: 1fr;
        gap: var(--wc-pix-spacing-sm);
    }
    
    .woocommerce-checkout #payment .payment_box .wc-pix-input,
    .wc-pix-input {
        padding: var(--wc-pix-spacing-sm) var(--wc-pix-spacing-md);
        font-size: var(--wc-pix-font-size-sm);
    }
}

@media (max-width: 480px) {
    .woocommerce-checkout #payment .payment_box .wc-pix-gateway-fields,
    .wc-pix-gateway-fields {
        padding: var(--wc-pix-spacing-md);
        border-radius: var(--wc-pix-border-radius);
    }
    
    .woocommerce-checkout #payment .payment_box .wc-pix-option,
    .wc-pix-option {
        padding: var(--wc-pix-spacing-sm) var(--wc-pix-spacing-md);
        flex-direction: column;
        text-align: center;
        gap: var(--wc-pix-spacing-xs);
    }
    
    .woocommerce-checkout #payment .payment_box .wc-pix-option input,
    .wc-pix-option input {
        width: 24px;
        height: 24px;
    }
    
    .woocommerce-checkout #payment .payment_box .wc-pix-option span,
    .wc-pix-option span {
        font-size: var(--wc-pix-font-size-sm);
    }
    
    .wc-pix-row {
        margin-bottom: var(--wc-pix-spacing-md);
    }
    
    .wc-pix-row label {
        font-size: var(--wc-pix-font-size-xs);
        margin-bottom: var(--wc-pix-spacing-xs);
    }
}


/* Ocultar informações do WooCommerce que aparecem antes do nosso template */
.woocommerce-order-details,
.woocommerce-order-overview,
.woocommerce-order-details__title,
.woocommerce-order-details__table,
.woocommerce-table--order-details,
.woocommerce-order-overview__order,
.woocommerce-order-overview__date,
.woocommerce-order-overview__total,
.woocommerce-order-overview__payment-method {
    display: none !important;
}

/* Ocultar elementos específicos do WooCommerce */
.woocommerce-order-details,
.woocommerce-order-overview,
.woocommerce-order-details__title,
.woocommerce-order-details__table,
.woocommerce-table--order-details,
.woocommerce-order-overview__order,
.woocommerce-order-overview__date,
.woocommerce-order-overview__total,
.woocommerce-order-overview__payment-method,
.woocommerce-order-details__table tbody tr,
.woocommerce-order-details__table thead tr,
.woocommerce-order-details__table td,
.woocommerce-order-details__table th {
    display: none !important;
}

/* Ocultar elementos que possam conter informações do pedido */
.woocommerce-order-details__table,
.woocommerce-order-overview,
.woocommerce-order-details__title {
    display: none !important;
}

/* Corrigir background do checkout para tema verde claro */
body.woocommerce-checkout,
body.woocommerce-page,
body.woocommerce-checkout .woocommerce,
body.woocommerce-checkout .woocommerce-page,
body.woocommerce-checkout .entry-content,
body.woocommerce-checkout .entry-summary,
body.woocommerce-checkout .woocommerce-checkout,
body.woocommerce-checkout .woocommerce-checkout .woocommerce,
body.woocommerce-checkout .woocommerce-checkout .woocommerce-page,
body.woocommerce-checkout .woocommerce-checkout .entry-content,
body.woocommerce-checkout .woocommerce-checkout .entry-summary {
    background: linear-gradient(135deg, var(--wc-pix-primary-lightest) 0%, var(--wc-pix-gray-50) 100%) !important;
    min-height: 100vh;
}

/* Corrigir background específico do WooCommerce */
.woocommerce-checkout #payment,
.woocommerce-checkout #payment .payment_box,
.woocommerce-checkout #payment .payment_box .payment_method_pix_gateway,
.woocommerce-checkout #payment .payment_box .payment_method_pix_gateway .payment_box,
.woocommerce-checkout #payment .payment_box .payment_method_pix_gateway .payment_box .wc-pix-gateway-fields {
    background: transparent !important;
}

/* Garantir que o container principal tenha o background correto */
.woocommerce-checkout .woocommerce-checkout,
.woocommerce-checkout .woocommerce-checkout .woocommerce,
.woocommerce-checkout .woocommerce-checkout .woocommerce-page {
    background: linear-gradient(135deg, var(--wc-pix-primary-lightest) 0%, var(--wc-pix-gray-50) 100%) !important;
}

/* Corrigir background do body quando estiver no checkout */
body.woocommerce-checkout {
    background: linear-gradient(135deg, var(--wc-pix-primary-lightest) 0%, var(--wc-pix-gray-50) 100%) !important;
}

/* Corrigir background do container principal do WooCommerce */
.woocommerce-checkout .woocommerce-checkout .woocommerce-checkout {
    background: transparent !important;
}

/* Garantir que o fundo seja aplicado corretamente */
body.woocommerce-checkout,
body.woocommerce-checkout .site-content,
body.woocommerce-checkout .content-area,
body.woocommerce-checkout .site-main {
    background: linear-gradient(135deg, var(--wc-pix-primary-lightest) 0%, var(--wc-pix-gray-50) 100%) !important;
}

</style>
<!-- JavaScript será carregado via arquivo externo frontend.js -->
